/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _LIB_ICON_COLLECTION_H_
#define _LIB_ICON_COLLECTION_H_

#include "c4d_library.h"


#define ICONFLAG_COPY				(1<<0)
#define ICONFLAG_OVERWRITE	(1<<1)

Bool RegisterIcon(LONG lIconID, BaseBitmap *pBmp, LONG x = 0, LONG y = 0, LONG w = -1, LONG h = -1, LONG lFlags = 0);
Bool RegisterIcon(LONG lIconID, Filename fn, LONG x = 0, LONG y = 0, LONG w = -1, LONG h = -1, LONG lFlags = 0); // always creates a copy (ICONFLAG_COPY set)
Bool GetIcon(LONG lIconID, IconData* pData);
Bool UnregisterIcon(LONG lIconID);

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#define LIBRARY_ICON_COLLECTION     1009310

struct IconCollectionLib : public C4DLibrary
{
  Bool        (*RegisterIconBitmap)(LONG lIconID, BaseBitmap *pBmp, LONG x, LONG y, LONG w, LONG h, LONG lFlags);
  Bool        (*RegisterIconFile)(LONG lIconID, Filename fn, LONG x, LONG y, LONG w, LONG h, LONG lFlags);
  Bool        (*GetIcon)(LONG lIconID, IconData* pData);
  Bool        (*UnregisterIcon)(LONG lIconID);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif // _LIB_ICON_COLLECTION_H_
