/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4D_COMMANDPLUGIN_H
#define __C4D_COMMANDPLUGIN_H

#include "ge_math.h"
#include "c4d_commanddata.h"
#include "c4d_baseplugin.h"

struct COMMANDPLUGIN : public STATICPLUGIN
{
	String			*help;
	BaseBitmap	*command_icon;

	Bool		(CommandData::*Execute				)(BaseDocument *doc);
	LONG		(CommandData::*GetState				)(BaseDocument *doc);
	Bool		(CommandData::*RestoreLayout	)(void *secret);
	void		(CommandData::*MessageEx			)(const BaseContainer &bc);
	String	(CommandData::*GetScriptName	)(void); 
	Bool		(CommandData::*GetSubContainer)(BaseDocument *doc, BaseContainer &submenu);
	Bool		(CommandData::*ExecuteSubID		)(BaseDocument *doc, LONG subid);
	Bool		(CommandData::*Message				)(LONG type, void *data);

	void*	reserved[(32-8)*C4DPL_MEMBERMULTIPLIER-2];
};

struct MANAGERINFORMATION : public STATICPLUGIN
{
	LONG info;

	void*	reserved[32*C4DPL_MEMBERMULTIPLIER-1];
};

#endif
