/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _C4D_LISTVIEW_H_
#define _C4D_LISTVIEW_H_

#include "operatingsystem.h"
#include "c4d_string.h"

class GeDialog;

inline void *_ReturnString(CHAR *v)
{ 
	return C4DOS.St->AllocCString((CHAR*)v,-1,StXbit); 
}

inline void *_ReturnString(const String &v)
{ 
	return C4DOS.St->GetClone(&v); 
}


struct MouseDownInfo
{
	LONG xpos,ypos,width,height;
	LONG line,col;

	Real mx;
	Real my;
	const BaseContainer *msg;
};


#define ReturnLong(v)   { res_type = LV_RES_LONG;   result = (void*)(VLONG)(v); return; }
#define ReturnBitmap(v) { res_type = LV_RES_BITMAP; result = (void*)(v); return; }
#define ReturnNull()    { res_type = LV_RES_NIL;    result = NULL; return; }
#define ReturnString(v) { res_type = LV_RES_STRING; result = _ReturnString(v); return; }
#define ReturnVector(v) { res_type = LV_RES_VECTOR; result = _ReturnVector(v); return; }



class GeListView
{
	protected:
		_GeListView *lv;
		GeDialog *cd;

	public:

		GeListView(void);
		virtual ~GeListView(void);

		virtual void LvCallBack(LONG &res_type,void *&result,void *secret,LONG cmd,LONG line,LONG col,void *data1);

		VLONG LvCallBackLong(void *secret,LONG cmd,LONG line,LONG col,void *data1);
		void LvSuperCall(LONG &res_type,void *&result,void *secret,LONG cmd,LONG line,LONG col);
		void Redraw(void);
		void DataChanged(void);
		Bool SendParentMessage(const BaseContainer &msg);
		LONG GetId(void);

		Bool ExtractMouseInfo(void *secret,MouseDownInfo &info,LONG size);
		Bool ExtractDrawInfo(void *secret,DrawInfo &info,LONG size);

		Bool AttachListView(GeDialog *cd,LONG id);
};

// for SetProperty & GetProperty
#define SLV_MULTIPLESELECTION 1

class SimpleListView : public GeListView
{
	public:

		SimpleListView();
		virtual ~SimpleListView();

		Bool SetLayout(LONG columns,const BaseContainer &data);
		Bool SetItem(LONG id,const BaseContainer &data);
		Bool GetItem(LONG id,BaseContainer *data);
		LONG GetItemCount(void);
		Bool GetItemLine(LONG num,LONG *id,BaseContainer *data);
		Bool RemoveItem(LONG id);
		LONG GetSelection(BaseSelect *selection);
		Bool SetSelection(BaseSelect *selection);
		LONG GetProperty(LONG id);
		Bool SetProperty(LONG id,LONG val);

		virtual void LvCallBack(LONG &res_type,void *&result,void *secret,LONG cmd,LONG line,LONG col,void *data1);
};

#endif
