/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _LIB_REG_EXPR_H_
#define _LIB_REG_EXPR_H_

#define REG_EXP_PARSER    1011197 

#define OPERATOR_CONCAT       1
#define ANY_CHAR              2
#define ANY_DIGIT             3

enum RegParseMode { RegParseMatch = 1, RegParseContains, RegParseStarts, RegParseEnds };

class RegularExprParser
{
private:
  RegularExprParser() { }
public:
  static RegularExprParser* Alloc();
  static void Free(RegularExprParser* p);
  
  Bool Init(const String &strExprssion);
  Bool FindFirst(const String &strText, RegParseMode mode, Bool bOnlyFirst, LONG &lPos, String &strPattern);
  Bool FindNext(LONG &lPos, String &strPattern);
  void CleanUp();
};


// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

class RegExpParser;
struct RegExprLib : public C4DLibrary
{
  RegExpParser* (*RegExprLib_Alloc)();
  void          (*RegExprLib_Free)(RegExpParser *&p);
  Bool          (RegExpParser::*Init)(const String &strExprssion);
  Bool          (RegExpParser::*FindFirst)(const String &strText, RegParseMode mode, Bool bOnlyFirst, LONG &lPos, String &strPattern);
  Bool          (RegExpParser::*FindNext)(LONG &lPos, String &strPattern);
  void          (RegExpParser::*CleanUp)();
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#endif // _LIB_REG_EXPR_H_