/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _CUSTOMGUI_DESCRIPTIONPROPERTY_H_
#define _CUSTOMGUI_DESCRIPTIONPROPERTY_H_

#include "customgui_base.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"
#include "lib_description.h"

class AtomArray;

#define CUSTOMGUI_DESCRIPTIONPROPERTY			1000485

#define DESCRIPTIONPROPERTY_COLOR_SEQ						10000	// vector: color of the circles
#define DESCRIPTIONPROPERTY_COLOR_KEY						10001	// vector: color of the circles
#define DESCRIPTIONPROPERTY_COLOR_NOANIM				10002	// vector: color of the circles
#define DESCRIPTIONPROPERTY_COLOR_ANIM					10003	// vector: color of the circles
#define DESCRIPTIONPROPERTY_COLOR_KEY_CHANGED		10004	// vector: color of the circles
#define DESCRIPTIONPROPERTY_SHOWBUTTON					10005 // Bool: show special button
#define DESCRIPTIONPROPERTY_INDENT							10006 // Bool: indent text
#define DESCRIPTIONPROPERTY_COLOR_SEQ_CHANGED		10007	// vector: color of the circles

#define DESCRIPTIONPROPERTY_PARENTMSG						20000

#define SETTING_AUTOIDENT			(1) // ident text if animationsymbol is visible
#define SETTING_HEIGHT				(2) // height

// BFM_ACTION props
#define BFM_ACTION_DP_MENUCLICK		'menu'
#define BFM_ACTION_DP_ADDSELECT		'adds'
#define BFM_ACTION_DP_SUBSELECT		'subs'
#define BFM_ACTION_DP_FOCUS				'dpfc'
#define BFM_ACTION_DP_ANIMCLICK		'anim'
#define BFM_ACTION_DP_BUTTONCLICK	'butt'
#define BFM_ACTION_QUAL						'qual'

// flags for Get/SetState
#define DESCPROP_SEQUENCE						(1<<0)
#define DESCPROP_KEY								(1<<1)
#define DESCPROP_AUTOKEY_ACTIVE			(1<<2)
#define DESCPROP_AUTOKEY_INACTIVE		(1<<3)
#define DESCPROP_NOANIM							(1<<4)
#define DESCPROP_ENABLED						(1<<5)
#define DESCPROP_ANIM_NOT_ALLOWED		(1<<6)
#define DESCPROP_GLOBAL_PARAMETER		(1<<7)
#define DESCPROP_MAXFONTBIT					(1<<8)
#define DESCPROP_KEY_CHANGED				(1<<9)

struct DescPropertyDragData
{
	AtomArray *arr;
	DescID		did;
};

class DescriptionPropertyCustomGui : public BaseCustomGui<CUSTOMGUI_DESCRIPTIONPROPERTY>
{
		DescriptionPropertyCustomGui();
		~DescriptionPropertyCustomGui();

	public:

		void SetDescID(const DescID &id);
		void SetState(LONG flags);
		LONG GetState();

		LONG GetPartCount();
		void GetPartInfo(LONG part,String &str,DescID &id,Bool &onoff);
		void SetSelection(const DescID &id,Bool onoff);
		void ChangeSettings(const BaseContainer &settings);
};





// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#ifndef _INTERNAL_DEF_
	class iDescriptionPropertyCustomGui : public iBaseCustomGui
	{
		iDescriptionPropertyCustomGui(const BaseContainer &settings,CUSTOMGUIPLUGIN *plugin) : iBaseCustomGui(settings,plugin) { }
	};
#else
	class iDescriptionPropertyCustomGui;
#endif

struct CustomGuiDescriptionPropertyLib : public BaseCustomGuiLib
{
	void (iDescriptionPropertyCustomGui::*SetState		)(LONG flags);
	LONG (iDescriptionPropertyCustomGui::*GetState		)();
	void (iDescriptionPropertyCustomGui::*SetDescID		)(const DescID &id);
	LONG (iDescriptionPropertyCustomGui::*GetPartCount)();
	void (iDescriptionPropertyCustomGui::*GetPartInfo )(LONG part,String &str,DescID &id,Bool &onoff);
	void (iDescriptionPropertyCustomGui::*SetSelection)(const DescID &id,Bool onoff);
	void (iDescriptionPropertyCustomGui::*ChangeSettings)(const BaseContainer &settings);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif
