/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4DBASESOUND_H
#define __C4DBASESOUND_H

#include "ge_math.h"
#include "c4d_basetime.h"
#include "c4d_baselist.h"

class BaseKey;
class Filename;
class BaseBitmap;

struct SData
{
	SWORD l;	// left channel
	SWORD r; // right channel
};

class BaseSound : public C4DAtom
{
	private:
		BaseSound();
		~BaseSound();
	public:
		BaseSound *GetClone(void);
		Bool CopyTo(BaseSound *dest);
	
		Bool Init(LONG samples, LONG fmode, Bool stereo, Bool b16);
		void FlushAll(void);
		Bool Load(const Filename &fn);
		Bool Save(const Filename &fn);

		CHAR *GetSoundInfo(Bool *stereo, Bool *b16, LONG *frequency, LONG *samples, BaseTime *length);
		
		void GetSample(LONG i, SData *data);
		void SetSample(LONG i, const SData &data);

		BaseBitmap *GetBitmap(LONG width, LONG height, const BaseTime &start, const BaseTime &stop);
		BaseBitmap *GetBitmap(LONG width, LONG height, const BaseTime &start, const BaseTime &stop, const Vector &draw_col, const Vector &back_col);

		Bool WriteIt(HyperFile *hf);
		Bool ReadIt (HyperFile *hf, LONG level);

		GeListHead  *GetMarkerRoot(void);

		CHAR *GetRAW(void);

		BaseSound *GetClonePart(const BaseTime &start,	const BaseTime &stop,	Bool reverse);

		static BaseSound *Alloc(void);
		static void Free(BaseSound *&v);
};

#endif
