#ifndef __SYSMATH_H
#define __SYSMATH_H

#include <math.h>

#pragma warning(disable:4244)
#pragma warning(disable:4305)
#pragma warning(disable:4996)
//#pragma warning(error:4701)

#ifdef __ICL // intel compiler warning
	#pragma warning(disable:181)  // argument is incompatible with corresponding format string conversion
	#pragma warning(disable:175)  // subscript out of range
	#pragma warning(disable:810)  // conversion from "unsigned __int64" to "LONG={long}" may lose significant bits
	#pragma warning(disable:1684)  // conversion from pointer to same-sized integral type (potential portability problem)
//#pragma warning(disable:1563) // use of temporaries
	#pragma warning(disable:1478) // sscanf, vsprintf deprecated
	#pragma warning(disable:1786) // Intel sscanf, vsprintf deprecated
#endif

#define __TYPES_READY

struct Matrix;
struct Vector;

#define FALSE 0
#define TRUE  1
#define NULL 	0


typedef short			          SWORD;
typedef unsigned short			UWORD;
typedef long 								LONG;
typedef unsigned long				ULONG;
typedef int                 Bool;
typedef float								SReal;
typedef double							LReal;
typedef void*								Hndl;
typedef int									INT;
typedef unsigned int 				UINT;
typedef char								CHAR;
typedef unsigned char				UCHAR;

#ifdef __C4D_64BIT
	#ifdef __ICL
		typedef long long LLONG;
		typedef unsigned long long LULONG;
		typedef unsigned long long VULONG;
		typedef signed long long VLONG;
	#else
		typedef _W64 __int64    LLONG;
		typedef _W64 unsigned __int64    LULONG;
		typedef _W64 unsigned __int64    VULONG;
		typedef _W64 signed __int64		   VLONG;
	#endif
#else
	typedef __int64							LLONG;
	typedef unsigned __int64		LULONG;
	typedef unsigned long				VULONG;
	typedef signed long					VLONG;
#endif

#undef MAXLONG // windows header have MINLONG defines as 0x80000000
#undef MINLONG // windows header have MINLONG defines as 0x80000000

#define MAXLONGl					0x7fffffff  
#define MAXLONGf					2147483520.0f		// 0x7FFFFF80 - rounding MAXLONG to Real results in 0x80000000
#define MAXLONGd					LReal(MAXLONGl)		
#define MINLONGl					(-0x7fffffff)		// explicitly not 0x80000000
#define MINLONGf					-2147483520.0f	// -0x7FFFFF80 - rounding MINLONG to Real results in 0x80000000
#define MINLONGd					LReal(MINLONGl)		

#ifndef MAXULONG
	#define MAXULONG					0xffffffff
#endif
#ifndef MAXWORD
	#define MAXWORD						32767L
#endif
#ifndef MAXUWORD
	#define MAXUWORD					65535L
#endif

typedef float								Real;
#define MAXREAL							( 9.0e18)
#define MINREAL							(-9.0e18)

#define NOTOK								(-1)

// use this defines to define float consts!
// e.g. instead of 10.0f write RC(10.0)
// speed up the 64 bit version some percent!
#define SCO(x)		SReal(x)	// defines float constants to SReal
#define RCO(x)		Real(x)		// defines float constants to Real
#define LCO(x)		LReal(x)	// defines float constants to LReal

#define pi			3.1415926535897932384626433832795
#define piinv		0.31830988618379067153776752674508	// 1/pi
#define pi2			6.283185307179586476925286766559
#define pi2inv	0.15915494309189533576888376337251	// 1/pi2
#define pi05		1.5707963267948966192313216916398
#define pi05inv 0.63661977236758134307553505349036	// 1/pi05

inline Real  FMin(Real a,  Real b) { if (a<b) return a; return b; }
inline LReal FMin(LReal a, LReal b) { if (a<b) return a; return b; }
inline LONG  LMin(LONG a,  LONG b) { if (a<b) return a; return b; }
inline VLONG VMin(VLONG a, VLONG b) { if (a<b) return a; return b; }

inline Real  FMax(Real a, Real b) { if (a<b) return b; return a; }
inline LReal FMax(LReal a, LReal b) { if (a<b) return b; return a; }
inline LONG  LMax(LONG a, LONG b) { if (a<b) return b; return a; }
inline VLONG VMax(VLONG a,VLONG b) { if (a<b) return b; return a; }

inline Real  FCut(Real  a,Real b,Real c) { if (a<b) return b; if (a>c) return c; return a; }
inline LReal FCut(LReal a,Real b,Real c) { if (a<b) return b; if (a>c) return c; return a; }
inline LONG  LCut(LONG  a,LONG b,LONG c) { if (a<b) return b; if (a>c) return c; return a; }
inline VLONG VCut(VLONG a,VLONG b,VLONG c) { if (a<b) return b; if (a>c) return c; return a; }
template <class A> inline A TCut(A a,A b,A c) { if (a<b) return b; if (a>c) return c; return a; }

#ifndef __ICL
	#define FtoL(x)		LONG(x)
	#define Abs(a)			(((a)<0)?-(a):(a))

	inline Real Sin(Real r)  { return (Real)sin((double)r); }
	inline Real Cos(Real r)  { return (Real)cos((double)r); }
	inline Real Tan(Real r)  { return (Real)tan((double)r); }
	inline Real ATan(Real r) { return (Real)atan((double)r); }
	inline Real Exp(Real r)  { return (Real)exp((double)r); }
	inline Real Ln(Real r)   { return (Real)log((double)r); }
	inline Real Ld(Real r)   { return (Real)log((double)r) / 0.69314718055994530941723212145818f; }
	inline Real Ln10(Real r) { return (Real)log10((double)r); }
	inline Real Sqrt(Real r) { return (Real)sqrt((double)r); }
	inline Real Floor(Real r){ return (Real)floor((double)r); }
	inline Real Ceil(Real r) { return (Real)ceil((double)r); }
	inline Real Cosh(Real r) { return (Real)cosh((double)r); }
	inline Real Sinh(Real r) { return (Real)sinh((double)r); }
	inline Real Tanh(Real r) { return (Real)tanh((double)r); }
	inline Real Pow(Real r,Real s)  { return (Real)pow((double)r,(double)s); }
	inline Real FMod(Real r,Real s) { return (Real)fmod((double)r,(double)s); }

	inline LReal Sin(LReal r)  { return sin(r); }
	inline LReal Cos(LReal r)  { return cos(r); }
	inline LReal Tan(LReal r)  { return tan(r); }
	inline LReal ATan(LReal r) { return atan(r); }
	inline LReal Exp(LReal r)  { return exp(r); }
	inline LReal Ln(LReal r)   { return log(r); }
	inline LReal Ld(LReal r)   { return log(r) / 0.69314718055994530941723212145818; }
	inline LReal Ln10(LReal r) { return log10(r); }
	inline LReal Sqrt(LReal r) { return sqrt(r); }
	inline LReal Floor(LReal r){ return floor(r); }
	inline LReal Ceil(LReal r) { return ceil(r); }
	inline LReal Cosh(LReal r) { return cosh(r); }
	inline LReal Sinh(LReal r) { return sinh(r); }
	inline LReal Tanh(LReal r) { return tanh(r); }
	inline LReal Pow(LReal r,LReal s)  { return pow(r,s); }
	inline LReal FMod(LReal r,LReal s) { return fmod(r,s); }

  inline Real ASin(Real val)
	{
		if(val>=1.0) return pi05;
		else if(val<=-1.0) return -pi05;
		return asin((double)val);
	}

	inline LReal ASin(LReal val)
	{
		if(val>=1.0) return pi05;
		else if(val<=-1.0) return -pi05;
		return asin((double)val);
	}

	inline Real ACos(Real val)
	{
		if(val>=1.0) return 0.0;
		else if(val<=-1.0) return pi;
		return acos((double)val);
	}

	inline LReal ACos(LReal val)
	{
		if(val>=1.0) return 0.0;
		else if(val<=-1.0) return pi;
		return acos((double)val);
	}

#else
	#define FtoL(x)		LONG(x)

	inline Real  Abs( Real f) { return fabs(f); }
	inline LReal Abs(LReal f) { return fabs(f); }
	template <class X> inline X Abs(X f) { if (f<0) return -f; return f; }

	inline Real Sin(Real r)  { return sin(r); }
	inline Real Cos(Real r)  { return cos(r); }
	inline Real Tan(Real r)  { return tan(r); }
	inline Real ATan(Real r) { return atan(r); }
	inline Real Exp(Real r)  { return exp(r); }
	inline Real Ln(Real r)   { return log(r); }
	inline Real Ld(Real r)   { return log(r) / 0.69314718055994530941723212145818f; }
	inline Real Ln10(Real r) { return log10(r); }
	inline Real Sqrt(Real r) { return sqrt(r); }
	inline Real Floor(Real r){ return floor(r); }
	inline Real Ceil(Real r) { return ceil(r); }
	inline Real Cosh(Real r) { return cosh(r); }
	inline Real Sinh(Real r) { return sinh(r); }
	inline Real Tanh(Real r) { return tanh(r); }
	inline Real Pow(Real r,Real s)  { return pow(r,s); }
	inline Real FMod(Real r,Real s) { return fmod(r,s); }
	inline Real ASin(Real val) { if(val>=1.0) return pi05; else if(val<=-1.0) return -pi05; return asin(val); }
	inline Real ACos(Real val) { if(val>=1.0) return 0.0; else if(val<=-1.0) return pi; return acos(val); }

	inline LReal Sin(LReal r)  { return sin(r); }
	inline LReal Cos(LReal r)  { return cos(r); }
	inline LReal Tan(LReal r)  { return tan(r); }
	inline LReal ATan(LReal r) { return atan(r); }
	inline LReal Exp(LReal r)  { return exp(r); }
	inline LReal Ln(LReal r)   { return log(r); }
	inline LReal Ld(LReal r)   { return log(r) / 0.69314718055994530941723212145818f; }
	inline LReal Ln10(LReal r) { return log10(r); }
	inline LReal Sqrt(LReal r) { return sqrt(r); }
	inline LReal Floor(LReal r){ return floor(r); }
	inline LReal Ceil(LReal r) { return ceil(r); }
	inline LReal Cosh(LReal r) { return cosh(r); }
	inline LReal Sinh(LReal r) { return sinh(r); }
	inline LReal Tanh(LReal r) { return tanh(r); }
	inline LReal Pow(LReal r,LReal s)  { return pow(r,s); }
	inline LReal FMod(LReal r,LReal s) { return fmod(r,s); }
	inline LReal ASin(LReal val) { if(val>=1.0) return pi05; else if(val<=-1.0) return -pi05; return asin(val); }
	inline LReal ACos(LReal val) { if(val>=1.0) return 0.0; else if(val<=-1.0) return pi; return acos(val); }
#endif

inline LONG LFloor(Real r)  { return LONG(Floor(r)); }
inline LONG LCeil(Real r)   { return LONG(Ceil(r));  }

inline LONG LFloor(LReal r) { return LONG(Floor(r)); }
inline LONG LCeil(LReal r)  { return LONG(Ceil(r));  }

inline Real  Rad(Real r)    { return ((r)*pi/180.0); }
inline LReal Rad(LReal r)   { return ((r)*pi/180.0); }
inline Real  Deg(Real r)    { return ((r)*180.0/pi); }
inline LReal Deg(LReal r)   { return ((r)*180.0/pi); }
inline void SinCos(Real w,Real &sn,Real &cn) { sn=Sin(w); cn=Cos(w); }
inline void SinCos(LReal w,LReal &sn,LReal &cn) { sn=Sin(w); cn=Cos(w); }

#define Mod(a,b)	((a)<0?((a)-(((a)-(b)+1)/(b))*(b)):(a)%(b))

inline LONG SAFELONG(Real x)
{
	if (x<=MINLONGf) return MINLONGl;
	else if (x>=MAXLONGf) return MAXLONGl;
	return LONG(x);
}

inline LONG SAFELONG(LReal x)
{
	if (x<=MINLONGd) return MINLONGl;
	else if (x>=MAXLONGd) return MAXLONGl;
	return LONG(x);
}

#endif
