
#include "lib_iconcollection.h"
#include "ge_autoptr.h"
#include "c4d_baselist.h"


#define LIBID			LIBRARY_ICON_COLLECTION
#define LIB				IconCollectionLib


static LIB *library = NULL;


static LIB *CheckLibObjectList(LONG offset)
{
	return (LIB*)CheckLib(LIBID,offset,(C4DLibrary**)&library);
}


Bool RegisterIcon(LONG lIconID, BaseBitmap * pBmp, LONG x, LONG y, LONG w, LONG h, LONG lFlags)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB, RegisterIconBitmap)); if (!lib || !lib->RegisterIconBitmap) return -1;
	return lib->RegisterIconBitmap(lIconID, pBmp, x, y, w, h, lFlags);
}

Bool RegisterIcon(LONG lIconID, Filename fn, LONG x, LONG y, LONG w, LONG h, LONG lFlags)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB, RegisterIconFile)); if (!lib || !lib->RegisterIconFile) return -1;
	return lib->RegisterIconFile(lIconID, fn, x, y, w, h, lFlags);
}

Bool GetIcon(LONG lIconID, IconData* pData)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB, GetIcon)); if (!lib || !lib->GetIcon) return FALSE;
	return lib->GetIcon(lIconID, pData);
}

Bool UnregisterIcon(LONG lIconID)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB, UnregisterIcon)); if (!lib || !lib->GetIcon) return FALSE;
	return lib->UnregisterIcon(lIconID);
}
