/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _CUSTOMGUI_LENSGLOW_H_
#define _CUSTOMGUI_LENSGLOW_H_

#include "c4d_library.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"
#include "c4d_customdatatype.h"
#include "customgui_base.h"


#define CUSTOMGUI_LENSGLOW			1000996
#define CUSTOMDATATYPE_LENSGLOW 1000997

#define MAXGLOW_CNT		5
#define MAXSTREAK_CNT	5

struct Streak
{
	Bool		random,randomlen,star;
	LONG		cnt,holecnt;
	Real		size,sv,holewidth,thickness,rot;
	Vector	col;
	LONG		type; 
};

struct Glow
{
	Real		size,sv;
	Vector	col;
	LONG		type;
};

struct Halo
{
	Real		size,sv;
	Vector	col;
	LONG		type;
};

class LensGlowStruct : public iCustomDataType<LensGlowStruct>
{
	public:
		Glow	 glow  [MAXGLOW_CNT];
		Streak streak[MAXSTREAK_CNT];
		Halo	 halo;
};

class LensGlowCustomGui : public BaseCustomGui<CUSTOMGUI_LENSGLOW>
{
		LensGlowCustomGui();
		~LensGlowCustomGui();
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#ifndef _INTERNAL_DEF_
	class iLensGlowCustomGui
	{
	};
#else
	class iLensGlowCustomGui;
#endif

struct CustomGuiLensGlowLib : public BaseCustomGuiLib
{
};

#endif
