#include "lib_editortools.h"


ObjectListLib *lib_objectlist = NULL;
EditorToolLib *lib_editortool = NULL; 


static ObjectListLib *CheckLibObjectList(LONG offset)
{
	return (ObjectListLib*)CheckLib(LIBRARY_OBJECTLIST,offset,(C4DLibrary**)&lib_objectlist);
}

static EditorToolLib *CheckLibEditorToolLib(LONG offset)
{
	return (EditorToolLib*)CheckLib(LIBRARY_EDITORTOOLS,offset,(C4DLibrary**)&lib_editortool);
}


C4DObjectList* C4DObjectList::Alloc()
{
	ObjectListLib *lib = CheckLibObjectList(LIBOFFSET(ObjectListLib,ObjectList_Alloc)); if (!lib) return NULL;
	return lib->ObjectList_Alloc();	
}

void C4DObjectList::Free(C4DObjectList *&ptr)
{
	if (!ptr) return;
	ObjectListLib *lib = CheckLibObjectList(LIBOFFSET(ObjectListLib,ObjectList_Free)); if (!lib) return;
	lib->ObjectList_Free(ptr);
	ptr=NULL;
}

LONG C4DObjectList::GetCount()
{
	ObjectListLib *lib = CheckLibObjectList(LIBOFFSET(ObjectListLib,ObjectList_GetCount)); if (!lib) return 0;
	return lib->ObjectList_GetCount(this);
}

BaseObject*	C4DObjectList::GetObject(LONG num)
{
	ObjectListLib *lib = CheckLibObjectList(LIBOFFSET(ObjectListLib,ObjectList_GetObject)); if (!lib) return NULL;
	return lib->ObjectList_GetObject(this,num);
}

Real C4DObjectList::GetZ(LONG num)
{
	ObjectListLib *lib = CheckLibObjectList(LIBOFFSET(ObjectListLib,ObjectList_GetZ)); if (!lib) return 0.0;
	return lib->ObjectList_GetZ(this,num);
}

LONG C4DObjectList::GetPolyIdx(LONG num)
{
	ObjectListLib *lib = CheckLibObjectList(LIBOFFSET(ObjectListLib,ObjectList_GetPolyIdx)); if (!lib) return 0;
	return lib->ObjectList_GetPolyIdx(this,num);
}

Bool C4DObjectList::AddObject(BaseObject *op, Real z, LONG polynum)
{
	ObjectListLib *lib = CheckLibObjectList(LIBOFFSET(ObjectListLib,ObjectList_AddObject)); if (!lib) return 0;
	return lib->ObjectList_AddObject(this,op,z,polynum);
}

Bool SelectionListCreate(BaseDocument *doc, BaseObject *parent, BaseDraw *bd, Real mx, Real my, LassoSelection *ls, C4DObjectList *list)
{
	EditorToolLib *lib = CheckLibEditorToolLib(LIBOFFSET(EditorToolLib,SelectionListCreate));
	if (!lib) return FALSE;
	return lib->SelectionListCreate(doc,parent,bd,mx,my,ls,list);
}

LONG SelectionListShowMenu(BaseDocument *doc, Real screenx, Real screeny, C4DObjectList *list)
{
	EditorToolLib *lib = CheckLibEditorToolLib(LIBOFFSET(EditorToolLib,SelectionListShowMenu));
	if (!lib) return FALSE;
	return lib->SelectionListShowMenu(doc, screenx, screeny, list);
}
