#include "c4d_tools.h"
#include "c4d_basetime.h"

void BaseTime::Reduce(void)
{ 
	Real z,n,m;

	z=Abs(nominator);
	n=Abs(denominator);

	if (z<MINSIZE || n<MINSIZE)
	{
		nominator=0.0;
		denominator=1.0;
	}
	else if (z<MAXLONGf && n<MAXLONGf)
	{
		LONG iz=(LONG)z,in=(LONG)n,im;
		
		do
		{
			im=iz%in;
			iz=in;in=im;
		}while(im);

		nominator/=Real(iz);
		denominator/=Real(iz);
	}
	else
	{
		LReal div = 1.0e18/FMax(LReal(z),LReal(n));
		if (div<1.0)
		{
			z*=div;
			n*=div;
			nominator*=div;
			denominator*=div;
		}
		if (n<1.0) { n=1.0; denominator=1.0; }
		
		do
		{
			m=FMod(z,n);
			z=n;n=m;
		}while(m>=0.5);

		nominator/=z;
		denominator/=z;
	}
}
